/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.menuworlds;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2784;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2874;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3568;
import net.minecraft.class_3610;
import net.minecraft.class_3980;
import net.minecraft.class_4538;
import net.minecraft.class_4543;
import net.minecraft.class_5294;
import net.minecraft.class_5455;
import net.minecraft.class_6539;
import net.minecraft.class_6880;
import net.minecraft.class_7699;

public class FakeBlockAccess
implements class_4538 {
    private final int version;
    private final long seed;
    private final class_2874 dimensionType;
    private final boolean isFlat;
    private final class_2680[] blocks;
    private final byte[] skylightmap;
    private final byte[] blocklightmap;
    private final class_1959[] biomemap;
    private final short[][] heightmap;
    private final int xSize;
    private final int ySize;
    private final int zSize;
    private float ground;
    public float effectiveGround;
    private final float rotation;
    private final boolean rain;
    private final boolean thunder;
    private final class_4543 biomeManager;
    private final class_5294 dimensionInfo;

    public FakeBlockAccess(int version, long seed, class_2680[] blocks, byte[] skylightmap, byte[] blocklightmap, class_1959[] biomemap, short[][] heightmap, int xSize, int ySize, int zSize, int ground, class_2874 dimensionType, boolean isFlat, float rotation, boolean rain, boolean thunder) {
        this.version = version;
        this.seed = seed;
        this.blocks = blocks;
        this.skylightmap = skylightmap;
        this.blocklightmap = blocklightmap;
        this.biomemap = biomemap;
        this.heightmap = heightmap;
        this.xSize = xSize;
        this.ySize = ySize;
        this.zSize = zSize;
        this.ground = ground - dimensionType.comp_651();
        this.dimensionType = dimensionType;
        this.isFlat = isFlat;
        this.rotation = rotation;
        this.rain = rain;
        this.thunder = thunder;
        this.biomeManager = new class_4543((class_4543.class_4544)this, class_4543.method_27984((long)seed));
        this.dimensionInfo = class_5294.method_28111((class_2874)dimensionType);
        class_2338 pos = new class_2338(0, (int)this.ground, 0);
        class_2680 standing = blocks[this.encodeCoords(pos)];
        this.ground += (float)Math.max(standing.method_26220((class_1922)this, pos).method_1105(class_2350.class_2351.field_11052), 0.0);
        this.effectiveGround = this.ground;
    }

    private int encodeCoords(int x, int z) {
        return z * this.xSize + x;
    }

    private int encodeCoords(int x, int y, int z) {
        return ((y + (int)this.effectiveGround) * this.zSize + (z + this.zSize / 2)) * this.xSize + (x + this.xSize / 2);
    }

    private int encodeCoords(class_2338 pos) {
        return this.encodeCoords(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    private boolean checkCoords(int x, int y, int z) {
        return x >= -this.xSize / 2 && y >= -((int)this.effectiveGround) && z >= -this.zSize / 2 && x < this.xSize / 2 && y < this.ySize - (int)this.effectiveGround && z < this.zSize / 2;
    }

    private boolean checkCoords(class_2338 pos) {
        return this.checkCoords(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public float getGround() {
        return this.effectiveGround;
    }

    public void setGroundOffset(float offset) {
        this.effectiveGround = this.ground + offset;
    }

    public int getXSize() {
        return this.xSize;
    }

    public int getYSize() {
        return this.ySize;
    }

    public int getZSize() {
        return this.zSize;
    }

    public long getSeed() {
        return this.seed;
    }

    public float getRotation() {
        return this.rotation;
    }

    public boolean getRain() {
        return this.rain;
    }

    public boolean getThunder() {
        return this.thunder;
    }

    public class_2874 method_8597() {
        return this.dimensionType;
    }

    public class_5294 getDimensionReaderInfo() {
        return this.dimensionInfo;
    }

    public double getVoidFogYFactor() {
        return this.isFlat ? 1.0 : 0.03125;
    }

    public double getHorizon() {
        return this.isFlat ? (double)(-this.effectiveGround) : 63.0 - (double)this.effectiveGround + (double)this.method_31607();
    }

    public class_2680 method_8320(class_2338 pos) {
        if (!this.checkCoords(pos)) {
            return class_2246.field_9987.method_9564();
        }
        class_2680 state = this.blocks[this.encodeCoords(pos)];
        return state != null ? state : class_2246.field_10124.method_9564();
    }

    public class_3610 method_8316(class_2338 pos) {
        return this.method_8320(pos).method_26227();
    }

    public class_2586 method_8321(class_2338 pos) {
        return null;
    }

    public int method_23752(class_2338 blockPosIn, class_6539 colorResolverIn) {
        int i = (Integer)class_310.method_1551().field_1690.method_41805().method_41753();
        if (i == 0) {
            return colorResolverIn.getColor((class_1959)this.method_23753(blockPosIn).comp_349(), (double)blockPosIn.method_10263(), (double)blockPosIn.method_10260());
        }
        int j = (i * 2 + 1) * (i * 2 + 1);
        int k = 0;
        int l = 0;
        int i1 = 0;
        class_3980 cursor3D = new class_3980(blockPosIn.method_10263() - i, blockPosIn.method_10264(), blockPosIn.method_10260() - i, blockPosIn.method_10263() + i, blockPosIn.method_10264(), blockPosIn.method_10260() + i);
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        while (cursor3D.method_17963()) {
            blockPos.method_10103(cursor3D.method_18671(), cursor3D.method_18672(), cursor3D.method_18673());
            int j1 = colorResolverIn.getColor((class_1959)this.method_23753((class_2338)blockPos).comp_349(), (double)blockPos.method_10263(), (double)blockPos.method_10260());
            k += (j1 & 0xFF0000) >> 16;
            l += (j1 & 0xFF00) >> 8;
            i1 += j1 & 0xFF;
        }
        return (k / j & 0xFF) << 16 | (l / j & 0xFF) << 8 | i1 / j & 0xFF;
    }

    public int method_8314(class_1944 type, class_2338 pos) {
        if (!this.checkCoords(pos)) {
            return 0;
        }
        if (type == class_1944.field_9284) {
            return this.dimensionType.comp_642() ? this.skylightmap[this.encodeCoords(pos)] : 0;
        }
        return type == class_1944.field_9282 ? this.blocklightmap[this.encodeCoords(pos)] : 0;
    }

    public int method_22335(class_2338 pos, int amount) {
        if (!this.checkCoords(pos.method_10263(), 0, pos.method_10260())) {
            return 0;
        }
        if (pos.method_10264() < 0) {
            return 0;
        }
        if (pos.method_10264() >= 256) {
            int light = 15 - amount;
            if (light < 0) {
                light = 0;
            }
            return light;
        }
        int light = (this.dimensionType.comp_642() ? this.skylightmap[this.encodeCoords(pos)] : 0) - amount;
        int blockLight = this.blocklightmap[this.encodeCoords(pos)];
        if (blockLight > light) {
            light = blockLight;
        }
        return light;
    }

    public float method_24852(class_2350 face, boolean shade) {
        boolean flag = this.dimensionInfo.method_29993();
        if (!shade) {
            return flag ? 0.9f : 1.0f;
        }
        return switch (face) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11033 -> {
                if (flag) {
                    yield 0.9f;
                }
                yield 0.5f;
            }
            case class_2350.field_11036 -> {
                if (flag) {
                    yield 0.9f;
                }
                yield 1.0f;
            }
            case class_2350.field_11043, class_2350.field_11035 -> 0.8f;
            case class_2350.field_11039, class_2350.field_11034 -> 0.6f;
        };
    }

    public boolean method_8393(int x, int z) {
        return this.checkCoords(x * 16, 0, z * 16);
    }

    public class_2791 method_8402(int x, int z, class_2806 requiredStatus, boolean nonnull) {
        return null;
    }

    public int method_8624(class_2902.class_2903 heightmapType, int x, int z) {
        if (heightmapType == class_2902.class_2903.field_13197) {
            return this.getHeightBlocking(x, z);
        }
        return 0;
    }

    public int getHeightBlocking(int x, int z) {
        return this.heightmap[x + this.xSize / 2][z + this.zSize / 2] - (int)this.effectiveGround;
    }

    public class_2338 method_8598(class_2902.class_2903 heightmapType, class_2338 pos) {
        return class_2338.field_10980;
    }

    public int method_8594() {
        return 0;
    }

    public class_2784 method_8621() {
        return new class_2784();
    }

    public boolean method_8611(class_1297 entityIn, class_265 shape) {
        return false;
    }

    public List<class_265> method_20743(@Nullable class_1297 entityIn, class_238 aabb) {
        return Collections.emptyList();
    }

    public boolean method_22347(class_2338 pos) {
        return this.method_8320(pos).method_26215();
    }

    public class_6880<class_1959> method_16359(int x, int y, int z) {
        int xMoved = x + this.xSize / 8;
        int yMoved = y + (int)this.effectiveGround / 4;
        int zMoved = z + this.zSize / 8;
        if (!this.checkCoords(x * 4, y * 4, z * 4)) {
            xMoved = class_3532.method_15340((int)xMoved, (int)0, (int)(this.xSize / 4 - 1));
            yMoved = class_3532.method_15340((int)yMoved, (int)0, (int)((this.ySize - (int)this.effectiveGround) / 4 - 1));
            zMoved = class_3532.method_15340((int)zMoved, (int)0, (int)(this.zSize / 4 - 1));
        }
        return class_6880.method_40223((Object)this.biomemap[(yMoved * (this.zSize / 4) + zMoved) * (this.xSize / 4) + xMoved]);
    }

    public int method_49805(class_2338 pos, class_2350 direction) {
        return 0;
    }

    public boolean method_8608() {
        return false;
    }

    public int method_8615() {
        return (int)(63.0f - this.effectiveGround + (float)this.method_31607());
    }

    public class_3568 method_22336() {
        return null;
    }

    public class_4543 method_22385() {
        return this.biomeManager;
    }

    public class_6880<class_1959> method_22387(int x, int y, int z) {
        return null;
    }

    public class_5455 method_30349() {
        return null;
    }

    public class_7699 method_45162() {
        return null;
    }
}

